/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;

public class AddonLoader {
    private static final Predicate<Path> ADDON_FILTER = path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".yuushya.jar");
    private static final Predicate<ResourceLocation> JSON_FILTER = resourceLocation -> resourceLocation.m_135815_().endsWith(".json");
    private static final FallbackResourceManager YUUSHYA_MANAGER = new FallbackResourceManager(PackType.SERVER_DATA, "yuushya");

    public static void loadPackResource(Path folder) {
        try (Stream<Path> files = Files.list(folder).filter(ADDON_FILTER).sorted(Comparator.comparing(Path::toString));){
            List<Path> fileList = files.toList();
            for (Path path : fileList) {
                try (FilePackResources packResource = new FilePackResources(path.toFile());){
                    YUUSHYA_MANAGER.m_215377_((PackResources)packResource);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getRegister() {
        for (Map.Entry entry : YUUSHYA_MANAGER.m_214159_("register", JSON_FILTER).entrySet()) {
            try {
                Resource resource = (Resource)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.m_215508_());){
                    JsonElement innerJson = JsonParser.parseReader((Reader)reader);
                    YuushyaRegistryConfig.mergeYuushyaRegistryBlockJson(innerJson.getAsJsonObject().getAsJsonArray("block"));
                    YuushyaRegistryData YuushyaData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(innerJson, YuushyaRegistryData.class);
                    YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void getCollision() {
        for (Map.Entry entry : YUUSHYA_MANAGER.m_214159_("collision", JSON_FILTER).entrySet()) {
            try {
                ResourceLocation file = (ResourceLocation)entry.getKey();
                ResourceLocation namespaceId1 = new ResourceLocation("yuushya", file.m_135815_().substring("collision/".length(), file.m_135815_().length() - ".json".length()));
                Resource resource = (Resource)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.m_215508_());){
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement, CollisionItem.class);
                    CollisionFileReader.getCollisionMap().put(namespaceId1.toString(), collision);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

